#include <QtGui>

#include "SHtableRelationDlg.h"
#include "mode1/erdiagram/Arrow.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Attribute.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/DrawERDlg.h"
#include "mode1/RelationInfo.h"

SHtableRelationDlg::SHtableRelationDlg(Arrow* arrow, QWidget *parent)
: QDialog(parent)
{
	tableRelaitonPage = new RelationPage();
	
	
	cardinalityMode = 1;
	zeroOneMoreRadio = new QRadioButton(tr("Zero / One or More"));
    oneMoreRadio = new QRadioButton(tr("One or More"));
    zeroOneRadio	=new QRadioButton(tr("Zero or One"));
	
	if( arrow->GetEndTableCardinality() == 1 ){
		zeroOneMoreRadio->setChecked(true);
	}
	
	else if( arrow->GetEndTableCardinality() == 2 ){
		oneMoreRadio->setChecked(true);
	}
	
	else if( arrow->GetEndTableCardinality() == 3 ){
		zeroOneRadio->setChecked(true);
	}
	
	applyBtn	= new QPushButton(tr("Ȯ"));
	cancelBtn	= new QPushButton(tr(""));
	
	connect(zeroOneMoreRadio, SIGNAL(clicked()), this, SLOT(ClickCardinaliryMode()));
	connect(oneMoreRadio, SIGNAL(clicked()), this, SLOT(ClickCardinaliryMode()));
	connect(zeroOneRadio, SIGNAL(clicked()), this, SLOT(ClickCardinaliryMode()));
	connect(applyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));
	
	
	QVBoxLayout *RadioLayout = new QVBoxLayout;
    RadioLayout->addWidget(zeroOneMoreRadio);
	RadioLayout->addWidget(oneMoreRadio);
	RadioLayout->addWidget(zeroOneRadio);

	QGroupBox *cardinalityGroupBox = new QGroupBox(tr("Cardinality"));
	cardinalityGroupBox->setLayout(RadioLayout);

	if(DrawERDlg::getInstance()->relaitonCardiMode == 4)
	{
		cardinalityGroupBox->setEnabled(0);
	}
	else
	{
		cardinalityGroupBox->setEnabled(1);
	}
	
	QHBoxLayout * BtnLayout = new QHBoxLayout;
	BtnLayout->addWidget(applyBtn);
	BtnLayout->addWidget(cancelBtn);
	BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);
	
	QVBoxLayout *RelaitonLayout = new QVBoxLayout;
    RelaitonLayout->addWidget(tableRelaitonPage);
	RelaitonLayout->addWidget(cardinalityGroupBox);
	RelaitonLayout->addLayout(BtnLayout);
    setLayout(RelaitonLayout);

	this->arrow = arrow;
	
	setGeometry(0,0,550,400);
	setWindowTitle(tr("̺  ̾α"));
	
	MakeRelationDialog();
}

void SHtableRelationDlg::MakeRelationDialog()
{
	this->tableRelaitonPage->selectTable->addItem(QIcon("Images/Table.png"), this->arrow->GetStartTable()->GetNameRect()->GetName()->toPlainText());
	this->tableRelaitonPage->relationTables->addItem(QIcon("Images/Table.png"), this->arrow->GetEndTable()->GetNameRect()->GetName()->toPlainText());
	
	int count = this->arrow->GetStartTable()->GetPrimaryRect()->GetPrimaryKeys().count();
	
	QStringList pkList;
	for( int i=0; i<count; i++){
		this->tableRelaitonPage->selectField->addItem(QIcon("Images/column.png"), (this->arrow->GetStartTable()->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText());
		pkList << (this->arrow->GetStartTable()->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText();
	}
	
	count = this->arrow->GetEndTable()->GetPrimaryRect()->GetPrimaryKeys().count();
	
	for( int i=0; i<count; i++){
		for( int j=0; j<pkList.count(); j++){
			if( pkList[j]+"(FK)" == (this->arrow->GetEndTable()->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText() ){
				this->tableRelaitonPage->relationField->addItem(QIcon("Images/column.png"),(this->arrow->GetEndTable()->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText());
			}
		}
		
	}
	
	count = this->arrow->GetEndTable()->GetAttributesRect()->GetAttributes().count();

	for( int i=0; i<count; i++){
		for( int j=0; j<pkList.count(); j++){
			if( pkList[j]+"(FK)" == (this->arrow->GetEndTable()->GetAttributesRect()->GetAttributes())[i]->toPlainText() ){
				this->tableRelaitonPage->relationField->addItem(QIcon("Images/column.png"),(this->arrow->GetEndTable()->GetAttributesRect()->GetAttributes())[i]->toPlainText());
			}
		}
	}
}
void SHtableRelationDlg::ClickCardinaliryMode()
{
	if(zeroOneMoreRadio->isChecked() == true)
	{
		cardinalityMode = 1;
		this->arrow->SetCardinality(1);
	}
	else if(oneMoreRadio->isChecked() == true)
	{
		cardinalityMode = 2;
		this->arrow->SetCardinality(2);
	}
	else if(zeroOneRadio->isChecked() == true)
	{
		cardinalityMode = 3;
		this->arrow->SetCardinality(3);
	}
	this->arrow->updatePosition();
}

int SHtableRelationDlg::getCardinalityMode()
{
	return cardinalityMode;
}

void SHtableRelationDlg::ClickApply()
{
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr("ϱ"),
		tr("  մϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::No | QMessageBox::Yes);
	
	if (closeMessage == QMessageBox::Yes){
		
		DrawERDlg::getInstance()->GetRelationInfo();

		QString fkName = this->GetTableRelaitonPage()->relaitonNameEdit->text();
		QString startTableName = this->arrow->GetStartTable()->GetNameRect()->GetName()->toPlainText();
		QString endTableName = this->arrow->GetEndTable()->GetNameRect()->GetName()->toPlainText();
		
		int state1 = this->GetTableRelaitonPage()->integrity->checkState() ? 1 : 0;
		int state2 = this->GetTableRelaitonPage()->allFieldUpdata->checkState() ? 1 : 0;
		
		RelationInfo* buffer = new RelationInfo(fkName, startTableName, endTableName, state1, state2);
		
		//if( this->arrow->GetMode() == 1 ){
			for(int i=0; i<this->arrow->GetStartTable()->GetPrimaryRect()->GetPrimaryKeys().count(); i++){
				buffer->AddFkItem((this->arrow->GetStartTable()->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText());
			}
		//}

		/*
		else if( this->arrow->GetMode() == 3 ){
			for(int i=0; i<this->arrow->GetStartTable()->GetAttributesRect()->GetAttributes().count(); i++){
				buffer->AddFkItem((this->arrow->GetStartTable()->GetAttributesRect()->GetAttributes())[i]->toPlainText());
			}
		}*/

		qDebug() << "Buffer:" << buffer->GetFkList();

		qDebug() << "FKName:" << fkName;
		
		DrawERDlg::getInstance()->GetRelationInfo() << buffer;

		this->close();
	}
}

void SHtableRelationDlg::ClickCancel()
{
	reject();
}


